/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.onetouch.capture._impl;

import com.digitalpersona.onetouch.DPFPCaptureFeedback;
import com.digitalpersona.onetouch.DPFPError;
import com.digitalpersona.onetouch.DPFPGlobal;
import com.digitalpersona.onetouch.DPFPSample;
import com.digitalpersona.onetouch.capture.DPFPCapture;
import com.digitalpersona.onetouch.capture.DPFPCaptureFactory;
import com.digitalpersona.onetouch.capture.DPFPCapturePriority;
import com.digitalpersona.onetouch.capture.event.DPFPDataEvent;
import com.digitalpersona.onetouch.capture.event.DPFPDataListener;
import com.digitalpersona.onetouch.capture.event.DPFPErrorEvent;
import com.digitalpersona.onetouch.capture.event.DPFPErrorListener;
import com.digitalpersona.onetouch.capture.event.DPFPImageQualityEvent;
import com.digitalpersona.onetouch.capture.event.DPFPImageQualityListener;
import com.digitalpersona.onetouch.capture.event.DPFPReaderStatusEvent;
import com.digitalpersona.onetouch.capture.event.DPFPReaderStatusListener;
import com.digitalpersona.onetouch.capture.event.DPFPSensorEvent;
import com.digitalpersona.onetouch.capture.event.DPFPSensorListener;
import com.digitalpersona.onetouch.jni.Acquisition;
import com.digitalpersona.onetouch.jni.DeviceEvent;
import com.digitalpersona.onetouch.jni.DeviceEventHandler;
import com.digitalpersona.onetouch.jni.JniException;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class DPFPCaptureFactoryImpl
implements DPFPCaptureFactory {
    public DPFPCapture createCapture() {
        return new CaptureImpl();
    }

    public DPFPCapture createCapture(String string) {
        return new CaptureImpl(string);
    }

    public DPFPCapture createCapture(DPFPCapturePriority dPFPCapturePriority) {
        return new CaptureImpl(dPFPCapturePriority);
    }

    public DPFPCapture createCapture(String string, DPFPCapturePriority dPFPCapturePriority) {
        return new CaptureImpl(string, dPFPCapturePriority);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CaptureImpl
    implements DPFPCapture {
        private DPFPCapturePriority priority = DPFPCapturePriority.CAPTURE_PRIORITY_NORMAL;
        private String readerSerialNumber = null;
        private Acquisition acquisition = null;
        private final EventListenerList listenerList = new EventListenerList();

        public CaptureImpl() {
        }

        public CaptureImpl(String string) {
            this();
            this.setReaderSerialNumber(string);
        }

        public CaptureImpl(DPFPCapturePriority dPFPCapturePriority) {
            this();
            this.setPriority(dPFPCapturePriority);
        }

        public CaptureImpl(String string, DPFPCapturePriority dPFPCapturePriority) {
            this();
            this.setReaderSerialNumber(string);
            this.setPriority(dPFPCapturePriority);
        }

        @Override
        public synchronized DPFPCapturePriority getPriority() {
            return this.priority;
        }

        @Override
        public synchronized void setPriority(DPFPCapturePriority dPFPCapturePriority) throws IllegalStateException {
            this.assertStopped();
            this.priority = dPFPCapturePriority;
        }

        @Override
        public synchronized String getReaderSerialNumber() {
            return this.readerSerialNumber;
        }

        @Override
        public synchronized void setReaderSerialNumber(String string) throws IllegalStateException {
            this.assertStopped();
            this.readerSerialNumber = string;
        }

        @Override
        public synchronized void startCapture() throws IllegalStateException {
            this.assertStopped();
            try {
                int n = this.priority == DPFPCapturePriority.CAPTURE_PRIORITY_HIGH ? 1 : (this.priority == DPFPCapturePriority.CAPTURE_PRIORITY_LOW ? 3 : 2);
                this.acquisition = new Acquisition(this.readerSerialNumber, n);
                this.acquisition.setHandler(new DeviceEventHandler(){
                    private String lastSerial = "{00000000-0000-0000-0000-000000000000}";

                    public void onEvent(DeviceEvent deviceEvent) {
                        if (deviceEvent == null) {
                            return;
                        }
                        if (deviceEvent.serialNumber == null) {
                            deviceEvent.serialNumber = this.lastSerial;
                        }
                        switch (deviceEvent.nEvent) {
                            case 0: {
                                DPFPSample dPFPSample;
                                try {
                                    dPFPSample = DPFPGlobal.getSampleFactory().createSample(deviceEvent.data);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    illegalArgumentException.printStackTrace();
                                    dPFPSample = null;
                                }
                                DPFPDataEvent dPFPDataEvent = new DPFPDataEvent(deviceEvent.serialNumber, dPFPSample);
                                for (DPFPDataListener dPFPDataListener : (DPFPDataListener[])CaptureImpl.this.getListeners(DPFPDataListener.class)) {
                                    dPFPDataListener.dataAcquired(dPFPDataEvent);
                                }
                                break;
                            }
                            case 1: {
                                DPFPErrorEvent dPFPErrorEvent = new DPFPErrorEvent(deviceEvent.serialNumber, new DPFPError(deviceEvent.errorCode));
                                for (DPFPErrorListener dPFPErrorListener : (DPFPErrorListener[])CaptureImpl.this.getListeners(DPFPErrorListener.class)) {
                                    dPFPErrorListener.errorOccured(dPFPErrorEvent);
                                }
                                break;
                            }
                            case 2: {
                                DPFPReaderStatusEvent dPFPReaderStatusEvent = new DPFPReaderStatusEvent(deviceEvent.serialNumber, 2);
                                for (DPFPReaderStatusListener dPFPReaderStatusListener : (DPFPReaderStatusListener[])CaptureImpl.this.getListeners(DPFPReaderStatusListener.class)) {
                                    dPFPReaderStatusListener.readerDisconnected(dPFPReaderStatusEvent);
                                }
                                break;
                            }
                            case 3: {
                                if (this.lastSerial == null && deviceEvent.serialNumber != null) {
                                    this.lastSerial = deviceEvent.serialNumber;
                                }
                                DPFPReaderStatusEvent dPFPReaderStatusEvent = new DPFPReaderStatusEvent(deviceEvent.serialNumber, 3);
                                for (DPFPReaderStatusListener dPFPReaderStatusListener : (DPFPReaderStatusListener[])CaptureImpl.this.getListeners(DPFPReaderStatusListener.class)) {
                                    dPFPReaderStatusListener.readerConnected(dPFPReaderStatusEvent);
                                }
                                break;
                            }
                            case 4: {
                                DPFPImageQualityEvent dPFPImageQualityEvent = new DPFPImageQualityEvent(deviceEvent.serialNumber, DPFPCaptureFeedback.values()[deviceEvent.errorCode]);
                                for (DPFPImageQualityListener dPFPImageQualityListener : (DPFPImageQualityListener[])CaptureImpl.this.getListeners(DPFPImageQualityListener.class)) {
                                    dPFPImageQualityListener.onImageQuality(dPFPImageQualityEvent);
                                }
                                break;
                            }
                            case 5: {
                                DPFPSensorEvent dPFPSensorEvent = new DPFPSensorEvent(deviceEvent.serialNumber, 5);
                                for (DPFPSensorListener dPFPSensorListener : (DPFPSensorListener[])CaptureImpl.this.getListeners(DPFPSensorListener.class)) {
                                    dPFPSensorListener.fingerTouched(dPFPSensorEvent);
                                }
                                break;
                            }
                            case 6: {
                                DPFPSensorEvent dPFPSensorEvent = new DPFPSensorEvent(deviceEvent.serialNumber, 6);
                                for (DPFPSensorListener dPFPSensorListener : (DPFPSensorListener[])CaptureImpl.this.getListeners(DPFPSensorListener.class)) {
                                    dPFPSensorListener.fingerGone(dPFPSensorEvent);
                                }
                                break;
                            }
                            case 7: {
                                if (deviceEvent.serialNumber != null) {
                                    this.lastSerial = deviceEvent.serialNumber;
                                }
                                DPFPSensorEvent dPFPSensorEvent = new DPFPSensorEvent(deviceEvent.serialNumber, 7);
                                for (DPFPSensorListener dPFPSensorListener : (DPFPSensorListener[])CaptureImpl.this.getListeners(DPFPSensorListener.class)) {
                                    dPFPSensorListener.imageAcquired(dPFPSensorEvent);
                                }
                                break;
                            }
                        }
                    }
                });
                this.acquisition.startEvents();
                this.acquisition.subscribe();
            }
            catch (JniException jniException) {
                throw new RuntimeException(jniException);
            }
        }

        @Override
        public synchronized void stopCapture() {
            if (!this.isStarted()) {
                return;
            }
            try {
                this.acquisition.unsubscribe();
            }
            catch (JniException jniException) {
                jniException.printStackTrace();
            }
            this.acquisition = null;
        }

        @Override
        public synchronized boolean isStarted() {
            return this.acquisition != null;
        }

        @Override
        public void addDataListener(DPFPDataListener dPFPDataListener) {
            this.listenerList.add(DPFPDataListener.class, dPFPDataListener);
        }

        @Override
        public void removeDataListener(DPFPDataListener dPFPDataListener) {
            this.listenerList.remove(DPFPDataListener.class, dPFPDataListener);
        }

        @Override
        public void addImageQualityListener(DPFPImageQualityListener dPFPImageQualityListener) {
            this.listenerList.add(DPFPImageQualityListener.class, dPFPImageQualityListener);
        }

        @Override
        public void removeImageQualityListener(DPFPImageQualityListener dPFPImageQualityListener) {
            this.listenerList.remove(DPFPImageQualityListener.class, dPFPImageQualityListener);
        }

        @Override
        public void addReaderStatusListener(DPFPReaderStatusListener dPFPReaderStatusListener) {
            this.listenerList.add(DPFPReaderStatusListener.class, dPFPReaderStatusListener);
        }

        @Override
        public void removeReaderStatusListener(DPFPReaderStatusListener dPFPReaderStatusListener) {
            this.listenerList.remove(DPFPReaderStatusListener.class, dPFPReaderStatusListener);
        }

        @Override
        public void addSensorListener(DPFPSensorListener dPFPSensorListener) {
            this.listenerList.add(DPFPSensorListener.class, dPFPSensorListener);
        }

        @Override
        public void removeSensorListener(DPFPSensorListener dPFPSensorListener) {
            this.listenerList.remove(DPFPSensorListener.class, dPFPSensorListener);
        }

        @Override
        public void addErrorListener(DPFPErrorListener dPFPErrorListener) {
            this.listenerList.add(DPFPErrorListener.class, dPFPErrorListener);
        }

        @Override
        public void removeErrorListener(DPFPErrorListener dPFPErrorListener) {
            this.listenerList.remove(DPFPErrorListener.class, dPFPErrorListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T extends EventListener> T[] getListeners(Class<T> clazz) {
            EventListenerList eventListenerList = this.listenerList;
            synchronized (eventListenerList) {
                return this.listenerList.getListeners(clazz);
            }
        }

        private void assertStopped() throws IllegalStateException {
            if (this.isStarted()) {
                throw new IllegalStateException();
            }
        }
    }
}

